-- 4_onSwipe
    
function setup()
    -- prepare any object with x,y,w,h fields, here a button
    button = {
    x = WIDTH/2,
    y = HEIGHT/2,
    w = WIDTH/4,
    h = HEIGHT/4,
    txt = "Swipe on me left, right, up, down"
    }
    -- ############### and add a Sensor to it  #################
    button.sensor = Sensor{ parent=button, xywhMode=RADIUS }
    button.sensor:onSwipe( function(event)
        -- event.dx and event.dy give the amount of swipe in pixels
        local dx,dy = 0,0
        if event.dx > 0 then dx = 1 end
        if event.dx < 0 then dx = -1 end
        if event.dy > 0 then dy = 1 end
        if event.dy < 0 then dy = -1 end
        local t1 = tween(0.5,button,{x=button.x+WIDTH/4*dx, y=button.y+HEIGHT/4*dy},tween.easing.cubicOut) 
        local t2 = tween(0.5,button,{x=button.x,y=button.y}, tween.easing.bounceOut) 
        tween.sequence(t1,t2)
        sound("Game Sounds One:Male Cheer 2")
    end)
    -- ############### #################  #################
end
function touched(t)
    -- ######### add this in your touched function #########
    if button.sensor:touched(t) then return true end
end
function draw()
    noStroke()
    background(178, 178, 178, 255)     
    fill(255, 190, 0, 255) -- button color
    rectMode(RADIUS)
    rect(button.x,button.y,button.w,button.h)
    fill(57, 57, 57, 255)         -- set color for text
    fontSize(50)            -- set font size
    textAlign(CENTER)
    textWrapWidth(button.w*1.8)
    text(button.txt,button.x,button.y)       -- draw text on screen)      
end
